package gov.va.med.mhv.bluebutton.converter;

import gov.va.med.mhv.bluebutton.model.StudyJob;
import gov.va.med.mhv.bluebutton.transfer.StudyJobDTO;

import java.util.ArrayList;
import java.util.List;

import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.core.convert.converter.Converter;
import org.springframework.stereotype.Component;


@Component
public class StudyJobListConverter implements Converter<List<StudyJob>, List<StudyJobDTO>> {

	@Autowired
	StudyJobConverter studyJobConverter;

	@Override
	public List<StudyJobDTO> convert(List<StudyJob> source) {
		List<StudyJobDTO> d = new ArrayList<StudyJobDTO>();
		if( source != null && source.size() != 0) {
			for(StudyJob s : source) {
				d.add(studyJobConverter.convert(s));
			}
		}
		return d;
	}

}
